/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.dimensions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.ServerWorldEventHandler;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.Server;
import noppes.npcs.api.INbt;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.handler.IDimensionHandler;
import noppes.npcs.api.handler.data.IWorldInfo;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.dimensions.CustomWorldInfo;
import noppes.npcs.dimensions.WorldCustom;
import org.apache.commons.io.FileUtils;

public class DimensionHandler
extends WorldSavedData
implements IDimensionHandler {
    static String NAME = "CustomNpcsHandler";
    private final Map<Integer, CustomWorldInfo> dimensionInfo = new TreeMap<Integer, CustomWorldInfo>();
    private final Map<Integer, UUID> toBeDeleted = new TreeMap<Integer, UUID>();

    public DimensionHandler(String mapName) {
        super(mapName);
    }

    public static DimensionHandler getInstance() {
        DimensionHandler INSTANCE = (DimensionHandler)Objects.requireNonNull(FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_175693_T()).func_75742_a(DimensionHandler.class, NAME);
        if (INSTANCE == null) {
            INSTANCE = new DimensionHandler();
            FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_175693_T().func_75745_a(NAME, (WorldSavedData)INSTANCE);
        }
        return INSTANCE;
    }

    public DimensionHandler() {
        super(NAME);
    }

    @Override
    public IWorldInfo createDimension() {
        CustomWorldInfo cwi = new CustomWorldInfo(new NBTTagCompound());
        this.createDimension(null, cwi);
        return cwi;
    }

    public void createDimension(EntityPlayerMP playerEntity, CustomWorldInfo worldInfo) {
        worldInfo.id = this.findFreeDimensionID();
        this.dimensionInfo.put(worldInfo.id, worldInfo);
        DimensionManager.registerDimension((int)worldInfo.id, (DimensionType)CustomNpcs.customDimensionType);
        this.loadDimension(worldInfo.id, worldInfo);
        if (playerEntity != null) {
            playerEntity.func_145747_a((ITextComponent)new TextComponentTranslation("message.dimensions.created", new Object[]{worldInfo.func_76065_j(), "" + worldInfo.id}));
        }
        this.syncWithClients();
    }

    /*
     * WARNING - void declaration
     */
    public void deleteDimension(ICommandSender sender, int dimensionID) {
        void var8_13;
        if (dimensionID < 100 || !this.dimensionInfo.containsKey(dimensionID)) {
            if (sender != null) {
                if (this.toBeDeleted.containsKey(dimensionID)) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("message.dimensions.err.del", new Object[0]));
                } else if (dimensionID >= 100) {
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("message.dimensions.err.notmod", new Object[0]));
                }
            }
            return;
        }
        WorldServer worldObj = DimensionManager.getWorld((int)dimensionID);
        if (!worldObj.field_73010_i.isEmpty()) {
            WorldServer world = Objects.requireNonNull(sender.func_184102_h()).func_71218_a(0);
            BlockPos coords = world.func_180504_m();
            if (coords == null) {
                coords = world.func_175694_M();
                if (!world.func_175623_d(coords)) {
                    coords = world.func_175672_r(coords);
                } else {
                    while (world.func_175623_d(coords) && coords.func_177956_o() > 0) {
                        coords = coords.func_177977_b();
                    }
                    if (coords.func_177956_o() == 0) {
                        coords = world.func_175672_r(coords);
                    }
                }
            }
            ArrayList<EntityPlayerMP> players = new ArrayList<EntityPlayerMP>();
            for (EntityPlayer entityPlayer : worldObj.field_73010_i) {
                if (!(entityPlayer instanceof EntityPlayerMP)) continue;
                entityPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("message.dimensions.tp.isdelete", new Object[0]));
                players.add((EntityPlayerMP)entityPlayer);
            }
            for (EntityPlayerMP entityPlayerMP : players) {
                NoppesUtilPlayer.teleportPlayer(entityPlayerMP, coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p(), 0, entityPlayerMP.field_70177_z, entityPlayerMP.field_70125_A);
            }
        }
        Entity entitySender = null;
        if (sender != null) {
            entitySender = sender.func_174793_f();
        }
        this.toBeDeleted.put(dimensionID, entitySender != null ? entitySender.func_110124_au() : null);
        DimensionManager.unloadWorld((int)dimensionID);
        ArrayList<WorldServer> list = new ArrayList<WorldServer>();
        WorldServer[] worldServerArray = CustomNpcs.Server.field_71305_c;
        int n = worldServerArray.length;
        boolean bl = false;
        while (var8_13 < n) {
            WorldServer w = worldServerArray[var8_13];
            if (w.field_73011_w.getDimension() != dimensionID) {
                list.add(w);
            }
            ++var8_13;
        }
        if (CustomNpcs.Server.field_71305_c.length != list.size()) {
            CustomNpcs.Server.field_71305_c = list.toArray(new WorldServer[0]);
        }
    }

    @Override
    public void deleteDimension(int dimensionID) {
        this.deleteDimension(null, dimensionID);
    }

    private int findFreeDimensionID() {
        int currentID = 100;
        while (this.dimensionInfo.containsKey(currentID)) {
            ++currentID;
        }
        return currentID;
    }

    @Override
    public int[] getAllIDs() {
        int[] arr = new int[this.dimensionInfo.size()];
        int j = 0;
        for (int i : this.dimensionInfo.keySet()) {
            if (i < 100 || this.toBeDeleted.containsKey(i)) continue;
            arr[j] = i;
            ++j;
        }
        return arr;
    }

    public Map<String, Integer> getMapDimensionsIDs() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Integer[] integerArray = DimensionManager.getStaticDimensionIDs();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int id = integerArray[i];
            WorldProvider provider = DimensionManager.createProviderFor((int)id);
            StringBuilder key = new StringBuilder((DimensionManager.getWorld((int)id) != null) + "&" + provider.func_186058_p().func_186065_b());
            if (this.dimensionInfo.containsKey(id)) {
                if (this.toBeDeleted.containsKey(id)) continue;
                key = new StringBuilder((DimensionManager.getWorld((int)id) != null) + "&" + this.dimensionInfo.get(id).func_76065_j());
            }
            while (map.containsKey(key + "&" + provider.func_186058_p().func_186067_c())) {
                key.append("_");
            }
            key.append("&").append(provider.func_186058_p().func_186067_c());
            map.put(key.toString(), id);
        }
        return map;
    }

    @Override
    public IWorldInfo getMCWorldInfo(int id) {
        return this.dimensionInfo.get(id);
    }

    @Override
    public INbt getNbt() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189551_b(nbt);
        return Objects.requireNonNull(NpcAPI.Instance()).getINbt(nbt);
    }

    public boolean isDelete(int id) {
        return this.toBeDeleted.containsKey(id);
    }

    public boolean func_76188_b() {
        return true;
    }

    private void loadDimension(int dimensionID, WorldInfo worldInfo) {
        WorldServer overworld = (WorldServer)FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_();
        try {
            DimensionManager.getProviderType((int)dimensionID);
        }
        catch (Exception e) {
            LogWriter.error("Cannot Hotload Dim: " + e);
            return;
        }
        MinecraftServer mcServer = overworld.func_73046_m();
        ISaveHandler savehandler = overworld.func_72860_G();
        assert (mcServer != null);
        EnumDifficulty difficulty = mcServer.func_130014_f_().func_175659_aa();
        WorldServer world = (WorldServer)new WorldCustom(worldInfo, mcServer, savehandler, dimensionID, overworld, mcServer.field_71304_b).func_175643_b();
        world.func_72954_a((IWorldEventListener)new ServerWorldEventHandler(mcServer, world));
        LogWriter.debug("Try Load World: " + dimensionID + "; world = " + world);
        try {
            Class.forName("org.orecruncher.dsurround.server.services.AtmosphereService");
        }
        catch (ClassNotFoundException e) {
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Load((World)world));
        }
        if (!mcServer.func_71264_H()) {
            world.func_72912_H().func_76060_a(mcServer.func_71265_f());
        }
        mcServer.func_147139_a(difficulty);
    }

    public void loadDimensions() {
        for (Map.Entry<Integer, CustomWorldInfo> entry : this.dimensionInfo.entrySet()) {
            int dimensionID = entry.getKey();
            try {
                DimensionManager.registerDimension((int)dimensionID, (DimensionType)CustomNpcs.customDimensionType);
                this.loadDimension(dimensionID, entry.getValue());
            }
            catch (Exception e) {
                LogWriter.error("Error Load Custom Dimensions [" + dimensionID + "]: ", e);
            }
        }
    }

    public void func_76184_a(@Nonnull NBTTagCompound nbt) {
        NBTTagList nbtList = nbt.func_150295_c("dimensionInfo", 10);
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound compound = nbtList.func_150305_b(i);
            this.dimensionInfo.put(compound.func_74762_e("dimensionID"), new CustomWorldInfo(compound.func_74775_l("worldInfo")));
        }
    }

    @Override
    public void setNbt(INbt nbt) {
        this.func_76184_a(nbt.getMCNBT());
    }

    private void syncWithClients() {
        int[] ids = this.getAllIDs();
        Server.sendToAll(CustomNpcs.Server, EnumPacketClient.DIMENSION_IDS, new Object[]{ids});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void unload(World world, int dimensionID) {
        if (this.dimensionInfo.containsKey(dimensionID)) {
            DimensionManager.unregisterDimension((int)dimensionID);
        }
        if (this.toBeDeleted.containsKey(dimensionID)) {
            uniqueID = this.toBeDeleted.get(dimensionID);
            this.toBeDeleted.remove(dimensionID);
            this.dimensionInfo.remove(dimensionID);
            ((WorldServer)world).func_73041_k();
            dimensionFolder = new File(DimensionManager.getCurrentSaveRootDirectory(), "DIM" + dimensionID);
            player = null;
            if (uniqueID != null) {
                player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(uniqueID);
            }
            try {
                FileUtils.deleteDirectory((File)dimensionFolder);
                ** if (player == null) goto lbl-1000
            }
            catch (IOException e) {
                try {
                    LogWriter.error(e);
                    if (player != null) {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.dimensions.err.notmod", new Object[]{"" + dimensionID}));
                    }
                    ** if (player == null) goto lbl-1000
                }
                catch (Throwable var7_7) {
                    if (player != null) {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("message.dimensions.del.folder", new Object[]{"" + dimensionID}));
                    }
                    throw var7_7;
                }
lbl-1000:
                // 1 sources

                {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("message.dimensions.del.folder", new Object[]{"" + dimensionID}));
                }
lbl-1000:
                // 2 sources

                {
                }
            }
lbl-1000:
            // 1 sources

            {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("message.dimensions.del.folder", new Object[]{"" + dimensionID}));
            }
lbl-1000:
            // 2 sources

            {
            }
            this.syncWithClients();
        }
    }

    @Nonnull
    public NBTTagCompound func_189551_b(@Nonnull NBTTagCompound nbt) {
        NBTTagList nbtList = new NBTTagList();
        for (Map.Entry<Integer, CustomWorldInfo> entry : this.dimensionInfo.entrySet()) {
            if (this.toBeDeleted.containsKey(entry.getKey())) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("dimensionID", entry.getKey().intValue());
            compound.func_74782_a("worldInfo", (NBTBase)entry.getValue().func_76082_a(null));
            nbtList.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a("dimensionInfo", (NBTBase)nbtList);
        return nbt;
    }
}

